#include <algorithm>
#include <cstdint>
#include <cstring>
#include <iostream>
#include <stack>
#include <tuple>
#include <unordered_map>
#include <vector>

typedef std::unordered_map<uint16_t, std::unordered_map<uint16_t, int16_t>> Graph;
constexpr int16_t INF = 30000;
constexpr int16_t NEG_INF = -30000;
constexpr int16_t unvisited = -1;

#define x first
#define y second

[[gnu::pure]] [[gnu::always_inline]]
inline int64_t squared_dist(int32_t a, int32_t b) {
	// ne moramo da racunamo tacnu distancu, i sqrt je skup
	return static_cast<int64_t>(a) * static_cast<int64_t>(a)
			 + static_cast<int64_t>(b) * static_cast<int64_t>(b);
}

[[gnu::pure]] [[gnu::hot]]
static std::pair<std::vector<int32_t>, int64_t> greedy(
	const std::vector<std::pair<int16_t, int16_t>>& v2s,
	const int32_t start
) {
	std::vector<int32_t> ids;
	std::pair<int64_t, int64_t> v2;
	int64_t dist, max_dist;
	const int32_t n = v2s.size();
	int32_t i;

	ids.reserve(n);
	ids.emplace_back(start);

	v2.x = v2s[start].x; v2.y = v2s[start].y;
	dist = squared_dist(v2.x, v2.y);
	max_dist = dist;

	for(i = 1; i < n; ++i) {
		if(i == start)
			continue;

		v2.x += v2s[i].x;
		v2.y += v2s[i].y;
		dist = squared_dist(v2.x, v2.y);
		if(dist > max_dist) {
			// prihvatamo jer je veca distanca
			ids.emplace_back(i);
			max_dist = dist;	
		} else {
			// backtrackujemo jer je odmogo, i idemo na sledeci vector
			v2.x -= v2s[i].x;
			v2.y -= v2s[i].y;
		}
	}

	return std::make_pair(ids, dist);
}

[[gnu::noreturn]]
static void solve(const std::vector<std::pair<int16_t, int16_t>>& v2s) {
	std::vector<int32_t> ids, max_ids;
	int64_t dist, max_dist;
	const int32_t n = v2s.size();
	int32_t i;
	
	// sad za svaki vektor probamo svaki vector
	for(i = 1, max_dist = INT64_MIN; i < n; ++i) {
		std::tie(ids, dist) = greedy(v2s, i);
		if (dist > max_dist) {
			max_dist = dist;
			max_ids = ids;
		}
	}

	std::cout << max_ids.size() << '\n';
	for(i = 0; i < max_ids.size(); ++i)
		std::cout << max_ids[i] << ' ';
	std::exit(0);
}

int main() noexcept {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  std::cout.tie(nullptr);
  std::cerr.tie(nullptr);

	/*
	ovo je malo komplikovano za nekog
	ko zna minimalno o vektorima, ali
	mislim da bruteforce treba da nam
	da oko 20 poena
	*/

	std::vector<std::pair<int16_t, int16_t>> v2s;
	int32_t n, i;

	std::cin >> n;
	++n; // zbog 1 indeksiranja

	v2s.resize(n);
	for(i = 1; i < n; ++i) {
		std::cin >> v2s[i].x;
		std::cin >> v2s[i].y;
	}
	
	solve(v2s);
}